"""
AI-AntiBot System
Advanced machine learning-based bot detection system that learns from Cloudflare Turnstile
"""

__version__ = "1.0.0"
__author__ = "AI-AntiBot Development Team"

from .training.trainer import TurnstileTrainer
from .models.detector import BotDetector
from .features.extractor import FeatureExtractor
from .dashboard.monitor import TrainingMonitor

__all__ = [
    'TurnstileTrainer',
    'BotDetector', 
    'FeatureExtractor',
    'TrainingMonitor'
]