"""
AI-AntiBot Configuration
"""
import os
from datetime import timedelta

class AIAntiBotConfig:
    """Configuration settings for AI-AntiBot system"""
    
    # Model configuration
    MODEL_VERSION = "1.0.0"
    MODEL_PATH = "ml_data/models/antibot_model.pkl"
    SCALER_PATH = "ml_data/models/feature_scaler.pkl"
    
    # Training configuration
    TRAINING_DATA_PATH = "ml_data/training_sets"
    TRAINING_BATCH_SIZE = 1  # Real-time training
    TRAINING_THRESHOLD = 1  # Real-time training after each sample
    
    # Feature extraction settings
    FEATURE_WINDOW_SIZE = 30  # seconds
    MAX_FEATURES = 50
    
    # Real-time monitoring
    DASHBOARD_UPDATE_INTERVAL = 5  # seconds
    MAX_DASHBOARD_ENTRIES = 1000
    MAX_TRAINING_SAMPLES = 1000  # Maximum total samples to keep
    
    # Learning parameters
    LEARNING_RATE = 0.001
    CONFIDENCE_THRESHOLD = 0.85
    RETRAINING_INTERVAL = timedelta(hours=24)
    
    # Storage settings
    LOG_RETENTION_DAYS = 30
    MAX_LOG_SIZE_MB = 100
    
    # Performance thresholds
    MIN_ACCURACY_THRESHOLD = 0.90
    MAX_FALSE_POSITIVE_RATE = 0.05
    
    @classmethod
    def get_model_path(cls):
        """Get the full path to the model file"""
        return os.path.join(os.path.dirname(__file__), '..', cls.MODEL_PATH)
    
    @classmethod
    def get_scaler_path(cls):
        """Get the full path to the scaler file"""
        return os.path.join(os.path.dirname(__file__), '..', cls.SCALER_PATH)
    
    @classmethod
    def get_training_data_path(cls):
        """Get the full path to training data directory"""
        return os.path.join(os.path.dirname(__file__), '..', cls.TRAINING_DATA_PATH)