# Web App Deployment Panel

## Overview

This Flask-based web application functions as a master deployment panel for deploying and managing phishing-like web apps (webmail clones) via API endpoints. It enables administrators to deploy various email client templates (e.g., Gmail, Yahoo, AOL, Office 365) as iframe applications. The system incorporates comprehensive security features, including bot detection, IP blocking, and form submission tracking, aiming to provide a robust platform for managing and monitoring these deployments.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Backend Architecture
- **Framework**: Flask with SQLAlchemy ORM.
- **Database**: SQLite3 (local file-based) for simplified deployment.
- **Authentication**: Flask-Login for session management.
- **Security**: Bot detection, IP blocking, and Cloudflare Turnstile CAPTCHA integration.
- **External Services**: Telegram for notifications, IP geolocation via IPInfo.io.
- **File Structure**: Streamlined modules (`api.py`, `routes.py`, `utils.py`) with an organized AI-AntiBot system.

### Frontend Architecture
- **Template Engine**: Jinja2.
- **CSS Framework**: Bootstrap 5.1.3.
- **JavaScript**: Vanilla JS with Bootstrap components.
- **Icons**: Font Awesome 6.0.0.
- **Theme**: Light grey and black admin interface.

### Application Structure
- **Modular Design**: Blueprints for main routes, authentication, and API endpoints.
- **Dynamic Template System**: Automatically discovers webapp templates from `templates/webapps/` directory.
- **Admin Panel**: Dashboard, results management, settings configuration, and app deployment.

### Key Features
- **AI-AntiBot Machine Learning System**: A comprehensive system with a modular architecture using PKL files for ML model persistence. It integrates a learning pipeline where Cloudflare Turnstile acts as a "teacher" for an internal AI system. This includes real-time training dashboards, feature extraction (mouse movements, timing, headers, user agent), and an ensemble ML model (Random Forest, Gradient Boosting). It supports per-webapp decision logic and logs AI decisions with confidence levels.
- **Dynamic App Serving**: Deployed apps are served via iframe with unique API keys.
- **Security Features**: User-Agent analysis, header validation, automatic IP blocking, Cloudflare Turnstile CAPTCHA, and Flask-Login session management.
- **Automatic Domain Management System**: Simplifies domain management by updating the base URL setting in the admin panel.

## External Dependencies

- **SQLite3 Database**: Primary data storage.
- **Telegram Bot**: For real-time notifications.
- **IPInfo.io API**: For IP geolocation and threat detection.
- **Cloudflare Turnstile**: For CAPTCHA protection.
- **Python Libraries**: Flask ecosystem (SQLAlchemy, Flask-Login), scikit-learn for ML models.
- **Client-side Libraries**: Bootstrap 5.1.3 (CDN), Font Awesome 6.0.0 (CDN), Cloudflare Turnstile (CDN).